/*
 * Decompiled with CFR 0.152.
 */
package club.someoneice.jellyfishingdelight.core;

import blueduck.jellyfishing.registry.ModBlocks;
import blueduck.jellyfishing.registry.ModItems;
import club.someoneice.jellyfishingdelight.core.BlockList;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public final class ModEvent {
    private static final Direction[] ROUND = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private static final ImmutableList<Supplier<Block>> CORAL_PLANTS = ImmutableList.of((Object)ModBlocks.CORAL_PLANT, (Object)ModBlocks.TUBE_PLANT, (Object)ModBlocks.LANTERN_PLANT, (Object)ModBlocks.DEEP_SPROUT);

    private static void setPlant(Level world, BlockPos pos, Block block, ItemStack item, boolean isCreative) {
        if (world.m_5776_()) {
            return;
        }
        if (!((Boolean)world.m_8055_(pos).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return;
        }
        if (!isCreative) {
            item.m_41774_(1);
        }
        Arrays.stream(ROUND).forEach(it -> {
            BlockPos nPos = pos.m_121945_(it);
            if (!world.m_6425_(nPos).m_205070_(FluidTags.f_13131_)) {
                return;
            }
            if (!block.m_7898_(world.m_8055_(nPos), (LevelReader)world, nPos)) {
                return;
            }
            if (world.m_213780_().m_188500_() > 0.3) {
                return;
            }
            world.m_46796_(1505, nPos, 0);
            BlockState state = (BlockState)block.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
            world.m_46597_(nPos, state);
        });
        BoneMealItem.m_40638_((LevelAccessor)world, (BlockPos)pos, (int)15);
    }

    private static void putKrabbyPatty(Level world, BlockPos pos, Player player, ItemStack item, @Nullable Direction face, InteractionHand hand, BlockHitResult hit) {
        BlockPos posIn;
        if (world.m_5776_() || Objects.isNull(face)) {
            return;
        }
        if (!player.m_6144_()) {
            return;
        }
        if (item.m_41619_() || !item.m_150930_((Item)ModItems.KRABBY_PATTY.get())) {
            return;
        }
        if (!((Block)BlockList.KRABBY_PATTY.get()).m_245993_(world.m_246046_())) {
            return;
        }
        BlockState state = ((Block)BlockList.KRABBY_PATTY.get()).m_5573_(new BlockPlaceContext(player, hand, item, hit));
        BlockPos blockPos = posIn = world.m_8055_(pos).m_247087_() ? pos : pos.m_121945_(face);
        if (!world.m_8055_(posIn).m_247087_()) {
            return;
        }
        if (!world.m_7731_(posIn, state, 11)) {
            return;
        }
        SoundType soundtype = state.getSoundType((LevelReader)world, posIn, (Entity)player);
        world.m_5594_(player, posIn, state.getSoundType((LevelReader)world, posIn, (Entity)player).m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        world.m_220407_(GameEvent.f_157797_, posIn, GameEvent.Context.m_223719_((Entity)player, (BlockState)state));
        if (!player.m_150110_().f_35937_) {
            item.m_41774_(1);
        }
    }

    private static void useBoneMeal(Level world, BlockPos pos, ItemStack item, Player player) {
        if (!item.m_150930_(Items.f_42499_)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60713_((Block)ModBlocks.TALL_LANTERN_PLANT.get())) {
            BoneMealItem.m_40638_((LevelAccessor)world, (BlockPos)pos, (int)15);
            world.m_46796_(1505, pos, 0);
            world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ((Block)ModBlocks.TALL_LANTERN_PLANT.get()).m_5456_().m_7968_()));
            return;
        }
        CORAL_PLANTS.stream().map(Supplier::get).filter(arg_0 -> ((BlockState)state).m_60713_(arg_0)).findFirst().ifPresent(it -> ModEvent.setPlant(world, pos, it, item, player.m_7500_()));
    }

    @SubscribeEvent
    public static void onUsingItem(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level world = event.getLevel();
        ItemStack item = event.getItemStack();
        BlockPos pos = event.getPos();
        ModEvent.putKrabbyPatty(world, pos, player, item, event.getFace(), event.getHand(), event.getHitVec());
        ModEvent.useBoneMeal(world, pos, item, player);
    }
}

